function em = scaleEMachineMap(em_name, rescaled_em_name, rescaled_em_ratedPower, rescaled_em_limitPower)
%scaleEMachineMap
% rescaled_em_ratedPower influenza la scalatura dei parametri principali e della mappa di
% efficienza
% rescaled_em_limitPower altera la curva limite di coppia per non superare la potenza limite

if strcmp(em_name, rescaled_em_name)
    error("")
end

em = loadEMachineMap(em_name);

% Scaling factor
base_ratedPower = em.ratedPwr;
scalingFactor = rescaled_em_ratedPower/base_ratedPower;

em.ratedPwr = rescaled_em_ratedPower;
em.inertia = em.inertia * scalingFactor;
em.mass = em.mass * scalingFactor;

% Torque limit map
maxTrq = em.maxTrq.Values * scalingFactor;
minTrq = em.minTrq.Values * scalingFactor;

% Saturate limit torque to not exceed the set limit power
spd = em.maxTrq.GridVectors{1};
maxPwr = maxTrq(spd~=0) .* spd(spd~=0);
limPwr = rescaled_em_limitPower * 1e3;
maxPwr( maxPwr > limPwr ) = limPwr;
maxTrq(spd~=0) = maxPwr ./ spd(spd~=0);

minPwr = minTrq(spd~=0) .* spd(spd~=0);
minPwr( minPwr < -limPwr ) = -limPwr;
minTrq(spd~=0) = minPwr ./ spd(spd~=0);

em.maxTrq = griddedInterpolant(spd, maxTrq);
em.minTrq = griddedInterpolant(spd, minTrq);

% Efficiency map
em.effMap.GridVectors{2} = em.effMap.GridVectors{2} * scalingFactor;

saveEMachineMap(em, rescaled_em_name);

end

